/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;

public class VSMXBoolean
extends VSMXBaseObject {
    public static final VSMXBoolean singletonTrue = new VSMXBoolean(true);
    public static final VSMXBoolean singletonFalse = new VSMXBoolean(false);
    private boolean value;

    private VSMXBoolean(boolean value) {
        super(null);
        this.value = value;
    }

    public static void init(VSMXInterpreter interpreter) {
        singletonTrue.setInterpreter(interpreter);
        singletonFalse.setInterpreter(interpreter);
    }

    public static VSMXBoolean getValue(boolean value) {
        return value ? singletonTrue : singletonFalse;
    }

    public static VSMXBoolean getValue(int value) {
        return VSMXBoolean.getValue(value != 0);
    }

    @Override
    public float getFloatValue() {
        return this.value ? 1.0f : 0.0f;
    }

    @Override
    public int getIntValue() {
        return this.value ? 1 : 0;
    }

    @Override
    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public String typeOf() {
        return "boolean";
    }

    @Override
    public String getClassName() {
        return "Boolean";
    }

    @Override
    public String toString() {
        return this.value ? "true" : "false";
    }
}

